local mod = {} -- will be filled with public functions

local settings = require('common.settings')
local colors = settings.colors
local fonts = settings.fonts

local anim_start = 0
local anim_started = false
local intro_anim_clip_size = vec2(500, 300)
local intro_logo_size = vec2(1024, 217) * 0.17 -- resolution of image scaled down

function mod.on_session_start()
    anim_started = false
    anim_start = 0
end

function mod.intro_anim_played()
    local elapsed = Time - anim_start
    return elapsed > 2
end

local function intro_anim()
    if DEV_IntroAnimOff then return end

    local center = settings.get_screensize() / 2
    local anim_t = math.clamp(settings.remap(Time - anim_start, 0.8, 1.0, 0, 1), 0, 1)
    local logo_clip_pos = center - intro_anim_clip_size / 2 + vec2(intro_anim_clip_size.x * anim_t, 0)
    ui.pushClipRect(logo_clip_pos, logo_clip_pos + intro_anim_clip_size)
    ui.drawImage(
        settings.get_asset("cmrt_complete_logo"),
        center - intro_logo_size,
        center + intro_logo_size
    )
    ui.popClipRect()
end

local function draw_logo(pos, width, length, color)
    for i=0, 5 do
        local angle = i * math.pi / 3
        local dir = vec2(math.cos(angle), math.sin(angle))
        ui.drawLine(pos + dir * width, pos + dir * (width + length), color, width * 1.1)
    end
end

local lights_on_sound = nil
local lights_start_sound = nil
local old_seconds_left = -100
local function race_startup_animation()
    if SemaphoresEnabled == false then return end
    local sim_info = ac.getSim()
    if sim_info.raceSessionType ~= ac.SessionType.Race then return end -- we don't want to draw it / play audio when not needed

    local screensize = settings.get_screensize()
    local center = screensize / 2

    if sim_info.timeToSessionStart < -1000 or sim_info.timeToSessionStart > 15000 then return end

    local logo_size = vec2(70, 70) * SemaphoresScale
    local logo_padding = 14 * SemaphoresScale

    local leftmost_center = center - vec2(logo_size.x * 1.5 + logo_padding * 1.5, screensize.y * 0.23)
    local max_len = 21 * SemaphoresScale
    local width = 11.2 * SemaphoresScale

    local time_to_start = 0.8 * sim_info.timeToSessionStart / 1000
    local time_to_delay = time_to_start - 2 -- 2 second delay

    -- pillola background
    local bg_appear = math.clamp(settings.remap(time_to_start, 7, 6.8, 0, 1), 0, 1)
    local bg_disappear = math.clamp(settings.remap(time_to_start, -0.1, -0.3, 0, 1), 0, 1)
    bg_appear = settings.ease_out_quad(bg_appear)
    bg_disappear = settings.ease_in_cubic(bg_disappear)
    if bg_appear > 0 and bg_disappear < 1 then
        local width = (logo_size.x + logo_padding) * 3
        local center_center = leftmost_center + vec2(width, 0) / 2
        local left = center_center + vec2(-width * bg_appear * (1 - bg_disappear), 0) / 2
        local right = center_center + vec2( width * bg_appear * (1 - bg_disappear), 0) / 2
        ui.pathClear()
        ui.pathArcTo(left, 50 * SemaphoresScale, math.pi / 2, math.pi * 3 / 2, 16)
        ui.pathArcTo(right, 50 * SemaphoresScale, -math.pi / 2, math.pi / 2, 16)
        ui.pathFillConvex(rgbm(60 / 255, 60 / 255, 60 / 255, 0.6))
    end
    
    --background
    if time_to_start > 0 and bg_appear >= 1 then
        local bg_appear = math.clamp(settings.remap(time_to_start, 6.7, 6.5, 0, 1), 0, 1)
        bg_appear = settings.ease_out_quad(bg_appear)
        local lerp = math.clamp(settings.remap(15 - time_to_start, 0, 0.1, 0, 1), 0, 1)
        for i=0, 3 do
            local current_pos = leftmost_center + vec2(logo_size.x + logo_padding, 0) * i
            draw_logo(current_pos, width, lerp * max_len * bg_appear, rgbm(255 / 255, 255 / 255, 255 / 255, 0.3))
        end
    end

    local seconds_left = math.floor(time_to_start - 0.3) -- if I do ceil I get -0 but I want +0
    if seconds_left ~= old_seconds_left then
        if Audio_MasterEnabled and Audio_SemaphoresOnEnabled then
            if seconds_left >= 1 and seconds_left <= 4 then
                if lights_on_sound ~= nil then lights_on_sound:dispose() end
                lights_on_sound = settings.get_single_audio_asset("CMRT UI lights on", 5.6 * Audio_SemaphoresOnVolume * Audio_MasterVolume)
                lights_on_sound:start()
            elseif seconds_left == -1 then
                if lights_start_sound ~= nil then lights_start_sound:dispose() end
                lights_start_sound = settings.get_single_audio_asset("CMRT UI start", 5.6 * Audio_SemaphoresOnVolume * Audio_MasterVolume)
                lights_start_sound:start()
            end
        end
        old_seconds_left = seconds_left
    end

    if sim_info.timeToSessionStart > 0 then
        for i=0, 3 do
            local current_pos = leftmost_center + vec2(logo_size.x + logo_padding, 0) * i
            local slot_lerp = math.clamp(4 - time_to_delay - i, 0, 1)
            local lerp = settings.remap(slot_lerp, 0.8, 1, 0, 1)
            lerp = settings.ease_out_cubic(lerp)
            if lerp > 0 then
                draw_logo(current_pos, width, lerp * max_len, colors.RED)
            end
        end
    else
        for i=0, 3 do
            local current_pos = leftmost_center + vec2(logo_size.x + logo_padding, 0) * i
            local slot_lerp = math.clamp(math.abs(time_to_start), 0, 1)
            local lerp = settings.remap(slot_lerp, 0.0, 0.3, 1, 0)
            lerp = settings.ease_in_cubic(lerp)
            if lerp > 0 then
                draw_logo(current_pos, width, lerp * max_len, colors.RED)
            end
        end
    end
end

function mod.main()
    if not anim_started then
        anim_started = true
        anim_start = Time
    end
    
    intro_anim()

    race_startup_animation()
end

return mod -- expose functions to the outside