local mod = {}
local settings = require('common.settings')
local players  = require('common.players')
local colors = settings.colors

local on_show_animation_start = 0
local is_showing = true
local is_paused = false
local is_damaged = false

local color_red = rgbm(255 / 255, 0 / 255, 0 / 255, 1)
local color_yellow = colors.TEXT_YELLOW --rgbm(254 / 255, 234 / 255, 0 / 255, 1)

local bump_damage = table.new(4,0)
local suspention_damage = table.new(4,0)
local tyre_damage = table.new(4,0)

local old_engine_damage = 0
local old_clutch_damage = 0

local old_bump_damage = table.new(4,0)
local old_suspention_damage = table.new(4,0)
local old_tyre_damage = table.new(4,0)


local engine_damage_time = -10
local clutch_damage_time = -10

local bump_damage_time = table.new(4,0)
local suspention_damage_time = table.new(4,0)
local tyre_damage_time = table.new(4,0)

local show_panel_time = -10

local alpha_val = 0

local function damage_animation(time, color)
    if Time - time < 1 then
        if math.fmod(Time - time, 0.1) > 0.05 then
            return  rgbm(color_red.r, color_red.g, color_red.b, alpha_val)
        else
            return  rgbm(1,1,1,alpha_val)
        end
    end
    return color
end

function mod.on_open()
    if is_paused == false then
        on_show_animation_start = Time
        is_showing = true
    end
    is_paused = false
end

function mod.on_close()
    is_paused = ac.getSim().isPaused
    if is_paused == false then
        is_showing = false
    end
end

local function calculate_current_color(lerp_t, alpha)
    local final_color = nil

    if lerp_t < 0.5 then
        final_color = settings.color_lerp(colors.WHITE, color_yellow, lerp_t * 2)
    end

    if lerp_t > 0.5 then
        final_color = settings.color_lerp(color_yellow, color_red, (lerp_t - 0.5) * 2)
    end

    final_color.mult = alpha

    return final_color
end

function mod.main()
    local focused, changed = players.get_focused_car()
    local car = ac.getCar(focused)
    local draw_top_left = vec2(0, 22)
    local draw_size = ui.windowSize() - vec2(0, 22)
    local draw_center = draw_top_left + draw_size / 2
    local panel_size = 250 * DamagePanel_Scale
    
    players.play_intro_anim_setup(draw_center, vec2(panel_size, panel_size), on_show_animation_start, is_showing)
    
    local clutch_png = settings.get_asset("clutch")
    local engine_png = settings.get_asset("engine")
    local front_bumper_png = settings.get_asset("front_bumper")
    local rear_bumpter_png = settings.get_asset("rear_bumper")
    local tyre_png = settings.get_asset("tyre")
    local suspention_png = settings.get_asset("susp")
    local side_png = settings.get_asset("side")

    alpha_val = 0

    if Time - show_panel_time < 5 then
        alpha_val = 1
    end

    if settings.is_inside(ui.mouseLocalPos(), ui.windowSize() / 2, ui.windowSize() / 2) or is_damaged or AlwaysShowDamagePanel then
        alpha_val = 1
    end

    
    local resize = 0.14
    local clutch_size = vec2(93,104) * resize * DamagePanel_Scale
    local engine_size = vec2(162,231) * resize * DamagePanel_Scale
    local front_bumper_size = vec2(579,176) * resize * DamagePanel_Scale
    local rear_bumpter_size = vec2(578,117) * resize * DamagePanel_Scale
    local tyre_size = vec2(114,208) * resize * DamagePanel_Scale
    local suspention_size = vec2(97,51) * resize * DamagePanel_Scale
    local side_size = vec2(55,192) * resize * DamagePanel_Scale

    local engine_damage =  1  - car.engineLifeLeft / 1000
    local clutch_damage = car.gearboxDamage

    if car.engineLifeLeft < 0 then
        engine_damage = 1
    end

    -- update bump damage
    for i = 0, 3 do
        bump_damage[i] = car.damage[i] / 60
        suspention_damage[i] = car.wheels[i].suspensionDamage
        tyre_damage[i] = car.wheels[i].tyreFlatSpot
    end

    local is_currently_damaged = false

    if engine_damage > 0.2 or clutch_damage > 0.2 then
        is_currently_damaged = true
    end

    for i = 0, 3 do
        if bump_damage[i] > 0.2 then is_currently_damaged = true end
        if suspention_damage[i] > 0.2 then is_currently_damaged = true end
    end

    if is_currently_damaged == false then
        if is_damaged == true then
            show_panel_time = Time
        end
        is_damaged = false
    end


    local dotsize = panel_size

    local bump_colors = table.new(4,0)
    local suspetion_colors = table.new(4,0)
    local tyre_colors = table.new(4,0)

    for i = 0, 3 do
        bump_colors[i] = calculate_current_color(math.clamp(bump_damage[i], 0 ,1), alpha_val)
        suspetion_colors[i] = calculate_current_color(suspention_damage[i], alpha_val)
        tyre_colors[i] = calculate_current_color(tyre_damage[i], alpha_val)
    end
    
    local engine_color = calculate_current_color(engine_damage, alpha_val)
    local clutch_color = calculate_current_color(clutch_damage, alpha_val)
    
    if engine_damage ~= old_engine_damage then
        engine_damage_time = Time
        old_engine_damage = engine_damage
        is_damaged = true
        show_panel_time = Time
    end

    if clutch_damage ~= old_clutch_damage then
        clutch_damage_time = Time
        old_clutch_damage = clutch_damage
        is_damaged = true
        show_panel_time = Time
    end

    for i = 0, 3 do
        if bump_damage[i] ~= old_bump_damage[i] then
            bump_damage_time[i] = Time
            old_bump_damage[i] = bump_damage[i]
            is_damaged = true
            show_panel_time = Time
        end

        if suspention_damage[i] ~= old_suspention_damage[i] then
            suspention_damage_time[i] = Time
            old_suspention_damage[i] = suspention_damage[i]
            is_damaged = true
            show_panel_time = Time
        end
        
        if tyre_damage[i] ~= old_tyre_damage[i] then
            tyre_damage_time[i] = Time
            old_tyre_damage[i] = tyre_damage[i]
        end
    end

    engine_color = damage_animation(engine_damage_time, engine_color)
    clutch_color = damage_animation(clutch_damage_time, clutch_color)

    for i = 0, 3 do
        bump_colors[i] = damage_animation(bump_damage_time[i], bump_colors[i])
        suspetion_colors[i] = damage_animation(suspention_damage_time[i], suspetion_colors[i])
        tyre_colors[i] = damage_animation(tyre_damage_time[i], tyre_colors[i])
    end
    
    ui.drawImage(
        settings.get_asset("dmg_bg"),
        draw_center - dotsize / 2,
        draw_center + dotsize / 2,
        rgbm(1,1,1,alpha_val)
    )

    local start_drawing = vec2(draw_center.x - front_bumper_size.x / 2, draw_center.y - 80 * DamagePanel_Scale)

    -- FRONT BUMPER
    ui.drawImage(
        front_bumper_png,
        start_drawing,
        start_drawing + front_bumper_size,
        bump_colors[0]
    )

    start_drawing = start_drawing + vec2(0, front_bumper_size.y + 7 * DamagePanel_Scale)

    -- TYRE Front LEFT
    ui.drawImage(
        tyre_png,
        start_drawing - vec2(tyre_size.x / 2 - 5 * DamagePanel_Scale,0),
        start_drawing - vec2(tyre_size.x / 2 - 5 * DamagePanel_Scale,0) + tyre_size,
        tyre_colors[0]
    )

    -- TYRE Front RIGHT
    ui.drawImage(
        tyre_png,
        start_drawing + vec2(front_bumper_size.x - tyre_size.x / 2 - 5 * DamagePanel_Scale, 0),
        start_drawing + vec2(front_bumper_size.x - tyre_size.x / 2 - 5 * DamagePanel_Scale, 0) + tyre_size,
        tyre_colors[1]
    )

    -- SUS Left
    ui.drawImage(
        suspention_png,
        start_drawing + vec2((tyre_size.x / 2 - 5 * DamagePanel_Scale) + (10 + 4) * DamagePanel_Scale, tyre_size.y / 2 - suspention_size.y / 2),
        start_drawing + vec2((tyre_size.x / 2 - 5 * DamagePanel_Scale) + (10 + 4) * DamagePanel_Scale, tyre_size.y / 2 - suspention_size.y / 2) + suspention_size,
        suspetion_colors[0]
    )

    -- SUS Right
    ui.drawImage(
        suspention_png,
        start_drawing + vec2(front_bumper_size.x - suspention_size.x - tyre_size.x + (5 - 6) * DamagePanel_Scale, tyre_size.y / 2 - suspention_size.y / 2),
        start_drawing + vec2(front_bumper_size.x - suspention_size.x - tyre_size.x + (5 - 6) * DamagePanel_Scale, tyre_size.y / 2 - suspention_size.y / 2) + suspention_size,
        suspetion_colors[1]
    )

    start_drawing = start_drawing + vec2(0, tyre_size.y / 2)

    -- ENGINE
    ui.drawImage(
        engine_png,
        start_drawing + vec2(front_bumper_size.x / 2 - engine_size.x / 2, 12 * DamagePanel_Scale) ,
        start_drawing + vec2(front_bumper_size.x / 2 - engine_size.x / 2, 12 * DamagePanel_Scale) + engine_size,
        engine_color
    )

    -- CLUTCH
    ui.drawImage(
        clutch_png,
        start_drawing + vec2(front_bumper_size.x / 2 - clutch_size.x / 2, engine_size.y + 6 + 12 * DamagePanel_Scale) ,
        start_drawing + vec2(front_bumper_size.x / 2 - clutch_size.x / 2, engine_size.y + 6 + 12 * DamagePanel_Scale) + clutch_size,
        clutch_color
    )

    start_drawing = start_drawing + vec2(0, tyre_size.y / 2 + 7 * DamagePanel_Scale) 

    -- Left Side
    ui.drawImage(
        side_png,
        start_drawing,
        start_drawing + side_size,
        bump_colors[2]
    )

    -- Right Side
    ui.drawImage(
        side_png,
        start_drawing + vec2(front_bumper_size.x - 8 * DamagePanel_Scale, 0),
        start_drawing + vec2(front_bumper_size.x - 8 * DamagePanel_Scale, 0) + side_size,
        bump_colors[3]
    )

    start_drawing = start_drawing + vec2(0, side_size.y + 7 * DamagePanel_Scale) 
    -- Left bottom tyre
    ui.drawImage(
        tyre_png,
        start_drawing - vec2(tyre_size.x / 2 - 5 * DamagePanel_Scale,0),
        start_drawing - vec2(tyre_size.x / 2 - 5 * DamagePanel_Scale,0) + tyre_size,
        tyre_colors[2]
    )

    -- Right bottom tyre        
    ui.drawImage(
        tyre_png,
        start_drawing + vec2(front_bumper_size.x - tyre_size.x / 2 - 5 * DamagePanel_Scale, 0),
        start_drawing + vec2(front_bumper_size.x - tyre_size.x / 2 - 5 * DamagePanel_Scale, 0) + tyre_size,
        tyre_colors[3]
    )

    -- SUS Left
    ui.drawImage(
        suspention_png,
        start_drawing + vec2((tyre_size.x / 2 - 5 * DamagePanel_Scale) + (10 + 4) * DamagePanel_Scale, tyre_size.y / 2 - suspention_size.y / 2),
        start_drawing + vec2((tyre_size.x / 2 - 5 * DamagePanel_Scale) + (10 + 4) * DamagePanel_Scale, tyre_size.y / 2 - suspention_size.y / 2) + suspention_size,
        suspetion_colors[2]
    )

    -- SUS Right
    ui.drawImage(
        suspention_png,
        start_drawing + vec2(front_bumper_size.x - suspention_size.x - tyre_size.x + (5 - 6) * DamagePanel_Scale, tyre_size.y / 2 - suspention_size.y / 2),
        start_drawing + vec2(front_bumper_size.x - suspention_size.x - tyre_size.x + (5 - 6) * DamagePanel_Scale, tyre_size.y / 2 - suspention_size.y / 2) + suspention_size,
        suspetion_colors[3]
    )

    start_drawing = start_drawing + vec2(0, tyre_size.y + 7 * DamagePanel_Scale) 

    ui.drawImage(
        rear_bumpter_png,
        start_drawing,
        start_drawing + rear_bumpter_size,
        bump_colors[1]
    )

    
    players.play_intro_anim(draw_center, vec2(panel_size, panel_size), on_show_animation_start, 1)
    settings.lock_app(draw_center, vec2(panel_size, panel_size), APPNAMES.damage_panel, 1)
    settings.auto_scale_window(vec2(panel_size, panel_size) * 1.01, APPNAMES.damage_panel)
    settings.auto_place_once(vec2(panel_size, panel_size), APPNAMES.damage_panel)
end

return  mod -- expose functions to the outside
